module load GATK/3.8.1
module load biobuilds

INVCF=FULL_IBD_postfilt.vcf.gz
OUTVCF=FULL_IBD__filt_recal.vcf.gz
REF=../HUMAN_REFS/HG38/hs38.fa

## Create the model for SNP
gatk3.8 -T VariantRecalibrator \
	-R $REF \
	-input $INVCF \
	--resource:hapmap,known=false,training=true,truth=true,prior=15.0 ../HUMAN_REFS/HG38/resources_broad_hg38_v0_hapmap_3.3.hg38.vcf \
	--resource:omni,known=false,training=true,truth=true,prior=12.0 ../HUMAN_REFS/HG38/resources_broad_hg38_v0_1000G_omni2.5.hg38.vcf \
	--resource:1000G,known=false,training=true,truth=false,prior=10.0 ../HUMAN_REFS/HG38/resources_broad_hg38_v0_1000G_phase1.snps.high_confidence.hg38.vcf \
	--resource:dbsnp,known=true,training=false,truth=false,prior=2.0 ../HUMAN_REFS/HG38/resources_broad_hg38_v0_Homo_sapiens_assembly38.dbsnp138.vcf \
	-an QD -an MQ -an MQRankSum -an ReadPosRankSum -an FS -an SOR -an InbreedingCoeff \
	-mode SNP \
	-tranche 100 -tranche 99.9 -tranche 99.0 -tranche 95.0 \
	--recal_file output.recal --rscript_file output.R --tranches_file output.tranches -nt 40

#Apply the model for SNP
gatk3.8 -T ApplyRecalibration -R $REF -input $INVCF -o temp1.vcf.gz --ts_filter_level 99.0 --tranches_file output.tranches --recal_file output.recal -mode SNP -nt 40

##Create model for INDELS
gatk3.8 -T VariantRecalibrator \
	-R $REF \
	-input temp1.vcf.gz \
	--resource:mills,known=false,training=true,truth=true,prior=12.0 ../HUMAN_REFS/HG38/resources_broad_hg38_v0_Mills_and_1000G_gold_standard.indels.hg38.vcf \
	--resource:dbsnp,known=true,training=false,truth=false,prior=2.0 ../HUMAN_REFS/HG38/resources_broad_hg38_v0_Homo_sapiens_assembly38.dbsnp138.vcf \
	-an QD -an MQRankSum -an ReadPosRankSum -an FS -an SOR -an InbreedingCoeff \
	-mode INDEL \
	-tranche 100 -tranche 99.9 -tranche 99.0 -tranche 95.0 \
	--recal_file output_indel.recal --rscript_file output_indel.R --tranches_file output_indel.tranches -nt 40

#Apply model for INDELS
gatk3.8 -T ApplyRecalibration -R $REF -input temp1.vcf.gz -o $OUTVCF --ts_filter_level 99.0 --tranches_file output_indel.tranches --recal_file output_indel.recal -mode INDEL -nt 40

